
// Copyright  2000-2010 Luigi Pino. All Rights Reserved.

/***************************************************************************/

#include "../neurosis/neurosis.h"
#include "extra.h"

#include <direct.h>

/***************************************************************************/

extern bool				gKicking;
extern bool				gMoving;
extern bool				gScrollMenu;
extern bool				gShowMenu;
extern bool				gWalking;
extern float			gDirection;
extern float			gMonsterMovement;
extern float			gScroll;
extern float3			gRain[];
extern CTiming		gTiming;
extern CWindow		gWindow;
extern SMonster		gMonster[];
extern STombstone	gTombstone[];
extern int				gKickingFrame;

/***************************************************************************/

void File_Get_Parameters()

{
	char		tempPath[MAX_PATH] = {NULL};
	CString	filename, folderBinary;

	// Get file location
	GetModuleFileName(NULL, tempPath, MAX_PATH);
	folderBinary.Format("%s", tempPath);
	filename.Format("%s", tempPath);
	while (filename.Find("\\") != -1)
	{
		while (filename.GetString()[0] != '\\')
			filename.Delete(0);
		filename.Delete(0);
	}
	folderBinary.Replace(filename, "");

	// Remove \ if there
	if ((folderBinary.GetLength() > 0) && (folderBinary.GetString()[folderBinary.GetLength()-1] == '\\'))
		folderBinary.Delete(folderBinary.GetLength()-1, 1);

	SetCurrentDirectory(folderBinary);
}

/***************************************************************************/

void Initialize_Values()

{
	// Initialize monsters
	gMonster[0].dead = false;			gMonster[0].hit = false;			gMonster[0].position = 8.0f;			gMonster[0].hitPoint = -7.9f;				gMonster[0].top = 0.0f;
	gMonster[1].dead = false;			gMonster[1].hit = false;			gMonster[1].position = 16.0f;			gMonster[1].hitPoint = -15.0f;			gMonster[1].top = 1.3f;
	gMonster[2].dead = false;			gMonster[2].hit = false;			gMonster[2].position = 24.0f;			gMonster[2].hitPoint = -22.0f;			gMonster[2].top = 0.2f;

	// Initialize rain
	for (int x1=0;x1<RAIN_TOTAL;x1=x1+1)
	{
		gRain[x1].x = (float)(Calculate_Random(RAIN_AREA * 2 * 100)) / 100.0f - (float)(RAIN_AREA);
		gRain[x1].y = (float)(Calculate_Random(RAIN_HEIGHT * 2 * 100)) / 100.0f;

		// Randomize rain speed => [RAIN_SPEED .. RAIN_SPEED + 1.0]
		gRain[x1].z = RAIN_SPEED + ((float)(Calculate_Random(100)) / 100.0f);
	}

	// Initialize tombstones
	gTombstone[0].height = -0.3f;			gTombstone[0].position = -2.0;
	gTombstone[1].height = -0.2f;			gTombstone[1].position = 1.0f;
	gTombstone[2].height = -0.4f;			gTombstone[2].position = 3.0f;
	gTombstone[3].height = -0.1f;			gTombstone[3].position = 4.5f;
	gTombstone[4].height = -0.5f;			gTombstone[4].position = 6.0f;
	gTombstone[5].height = -0.2f;			gTombstone[5].position = 8.0f;
}

/***************************************************************************/

void Update_Input_Keyboard()

{
	// Check escape key
	if (gWindow.pKeys[VK_ESCAPE] == true)
		gWindow.mQuit = true;

	// Exit from intro screen
	if ((gWindow.pKeys[VK_RETURN]) && (gShowMenu == true))
		gScrollMenu = true;

	// Move
	gMoving = true;
	if (gKickingFrame > 1)
	{
		gKicking = true;
		gWalking = false;
	}
	else if (gWindow.pKeys[VK_LEFT])
	{
		gKicking = false;
		gWalking = true;
		gDirection = -1.0f;
	}
	else if (gWindow.pKeys[VK_RIGHT])
	{
		gKicking = false;
		gWalking = true;
		gDirection = 1.0f;
	}
	else if (gWindow.pKeys[VK_SPACE])
	{
		gKicking = true;
		gWalking = false;
	}
	else
		gMoving = false;

	gWindow.pKeys[VK_LEFT] = false;
	gWindow.pKeys[VK_RIGHT] = false;
	gWindow.pKeys[VK_RETURN] = false;
}

/***************************************************************************/

void Update_Game()

{
	gMonsterMovement = gMonsterMovement + (200.0f * gTiming.mInterval);

	if (gMonsterMovement > 100.0f)
		gMonsterMovement = 0.0f;

	if (gMonster[0].hit == true)
	{
		gMonster[0].top = gMonster[0].top - (4.0f * gTiming.mInterval);
		if (gMonster[0].top < -1.4f)
			gMonster[0].dead = true;
	}

	if (gMonster[1].hit == true)
	{
		gMonster[1].top = gMonster[1].top - (4.0f * gTiming.mInterval);
		if (gMonster[1].top < -1.4f)
			gMonster[1].dead = true;
	}

	if (gMonster[2].hit == true)
	{
		gMonster[2].top = gMonster[2].top - (4.0f * gTiming.mInterval);
		if (gMonster[2].top < -1.4f)
			gMonster[2].dead = true;
	}
}

/***************************************************************************/